/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

class ShadowOfTheEnemySpendManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    public ShadowOfTheEnemySpendManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.Custom, Outcome.Benefit);
        this.staticText = "and you may spend mana as though it were mana of any type to cast those spells";
    }

    private ShadowOfTheEnemySpendManaEffect(ShadowOfTheEnemySpendManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public ShadowOfTheEnemySpendManaEffect copy() {
        return new ShadowOfTheEnemySpendManaEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if ((objectId = CardUtil.getMainCardId((Game)game, (UUID)objectId)).equals(((FixedTarget)this.getTargetPointer()).getTarget()) && game.getState().getZoneChangeCounter(objectId) <= ((FixedTarget)this.getTargetPointer()).getZoneChangeCounter() + 1) {
            return source.isControlledBy(affectedControllerId);
        }
        if (((FixedTarget)this.getTargetPointer()).getTarget().equals(objectId)) {
            this.discard();
        }
        return false;
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

