/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.common.PreventNextDamageFromChosenSourceEffect;
import mage.cards.s.ShadowbanePreventionApplier;
import mage.constants.Duration;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ShadowbanePreventionEffect
extends PreventNextDamageFromChosenSourceEffect {
    ShadowbanePreventionEffect() {
        super(Duration.EndOfTurn, false, (PreventNextDamageFromChosenSourceEffect.ApplierOnPrevention)ShadowbanePreventionApplier.instance);
    }

    private ShadowbanePreventionEffect(ShadowbanePreventionEffect effect) {
        super((PreventNextDamageFromChosenSourceEffect)effect);
    }

    public PreventNextDamageFromChosenSourceEffect copy() {
        return new ShadowbanePreventionEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game)) {
            return false;
        }
        UUID controllerId = source.getControllerId();
        UUID targetId = event.getTargetId();
        if (targetId.equals(controllerId)) {
            return true;
        }
        Permanent permanent = game.getPermanent(targetId);
        return StaticFilters.FILTER_CONTROLLED_CREATURE.match(permanent, controllerId, source, game);
    }
}

