/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class ShadowfaxLordOfHorsesEffect
extends OneShotEffect {
    ShadowfaxLordOfHorsesEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may put a creature card with lesser power from your hand onto the battlefield tapped and attacking.";
    }

    private ShadowfaxLordOfHorsesEffect(ShadowfaxLordOfHorsesEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShadowfaxLordOfHorsesEffect copy() {
        return new ShadowfaxLordOfHorsesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Permanent shadowfax = source.getSourcePermanentOrLKI(game);
        if (shadowfax == null) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("a creature card with lesser power");
        filter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, shadowfax.getPower().getValue()));
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)filter);
        target.withNotTarget(true);
        if (!player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game)) {
            return false;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            game.getCombat().addAttackingCreature(permanent.getId(), game);
        }
        return true;
    }
}

