/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ShadowgrangeArchfiendEffect
extends OneShotEffect {
    ShadowgrangeArchfiendEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent sacrifices a creature with the greatest power among creatures they control. You gain life equal to the greatest power among creatures sacrificed this way";
    }

    private ShadowgrangeArchfiendEffect(ShadowgrangeArchfiendEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShadowgrangeArchfiendEffect copy() {
        return new ShadowgrangeArchfiendEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Permanent> toSacrifice = new ArrayList<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player opponent;
            if (!controller.hasOpponent(playerId, game) || (opponent = game.getPlayer(playerId)) == null) continue;
            int greatestPower = Integer.MIN_VALUE;
            int numberOfCreatures = 0;
            Permanent creatureToSacrifice = null;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, playerId, game)) {
                if (permanent.getPower().getValue() > greatestPower) {
                    greatestPower = permanent.getPower().getValue();
                    numberOfCreatures = 1;
                    creatureToSacrifice = permanent;
                    continue;
                }
                if (permanent.getPower().getValue() != greatestPower) continue;
                ++numberOfCreatures;
            }
            if (numberOfCreatures > 1) {
                FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature to sacrifice with power equal to " + greatestPower);
                filter.add((Predicate)new PowerPredicate(ComparisonType.EQUAL_TO, greatestPower));
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                if (opponent.choose(this.outcome, (Target)target, source, game)) {
                    creatureToSacrifice = game.getPermanent(target.getFirstTarget());
                }
            }
            if (creatureToSacrifice == null) continue;
            toSacrifice.add(creatureToSacrifice);
        }
        int greatestPowerAmongAllCreaturesSacked = Integer.MIN_VALUE;
        for (Permanent permanent : toSacrifice) {
            int powerOfCurrentCreature = permanent.getPower().getValue();
            if (!permanent.sacrifice(source, game) || powerOfCurrentCreature <= greatestPowerAmongAllCreaturesSacked) continue;
            greatestPowerAmongAllCreaturesSacked = powerOfCurrentCreature;
        }
        if (greatestPowerAmongAllCreaturesSacked > 0) {
            new GainLifeEffect(greatestPowerAmongAllCreaturesSacked).apply(game, source);
        }
        return true;
    }
}

