/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Objects;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;

class ShadowsVerdictEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreatureOrPlaneswalkerPermanent();
    private static final FilterCard filter2 = new FilterCard();
    private static final Predicate<MageObject> predicate = new ManaValuePredicate(ComparisonType.FEWER_THAN, 4);

    ShadowsVerdictEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all creatures and planeswalkers with mana value 3 or less from the battlefield and all creature and planeswalker cards with mana value 3 or less from all graveyards";
    }

    private ShadowsVerdictEffect(ShadowsVerdictEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShadowsVerdictEffect copy() {
        return new ShadowsVerdictEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).stream().forEach(arg_0 -> ((Cards)cards).add(arg_0));
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).map(g -> g.getCards(filter2, game)).flatMap(Collection::stream).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        return player.moveCards((Cards)cards, Zone.EXILED, source, game);
    }

    static {
        filter.add(predicate);
        filter2.add(predicate);
        filter2.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

