/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShakedownHeavyEffect
extends OneShotEffect {
    ShakedownHeavyEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player may have you draw a card. If they do, untap {this} and remove it from combat";
    }

    private ShakedownHeavyEffect(ShakedownHeavyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShakedownHeavyEffect copy() {
        return new ShakedownHeavyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player defender = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || defender == null || !defender.chooseUse(this.outcome, "Have " + controller.getName() + " draw a card?", source, game)) {
            return false;
        }
        controller.drawCards(1, source, game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.untap(game);
            permanent.removeFromCombat(game);
        }
        return true;
    }
}

