/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.TargetSource;

class ShamanEnKorRedirectFromTargetEffect
extends RedirectionEffect {
    private static FilterCreaturePermanent filter = new FilterCreaturePermanent();
    protected MageObjectReference sourceObject;

    ShamanEnKorRedirectFromTargetEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next time a source of your choice would deal damage to target creature this turn, that damage is dealt to {this} instead";
    }

    private ShamanEnKorRedirectFromTargetEffect(ShamanEnKorRedirectFromTargetEffect effect) {
        super((RedirectionEffect)effect);
        this.sourceObject = effect.sourceObject;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetSource target = new TargetSource();
            target.choose(Outcome.PreventDamage, player.getId(), source.getSourceId(), source, game);
            this.sourceObject = new MageObjectReference(target.getFirstTarget(), game);
        } else {
            this.discard();
        }
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && filter.match(permanent, permanent.getControllerId(), source, game) && this.sourceObject.equals((Object)new MageObjectReference(event.getSourceId(), game))) {
            this.redirectTarget = new TargetPermanent();
            this.redirectTarget.add(source.getSourceId(), game);
            return event.getTargetId().equals(this.getTargetPointer().getFirst(game, source));
        }
        return false;
    }

    public ShamanEnKorRedirectFromTargetEffect copy() {
        return new ShamanEnKorRedirectFromTargetEffect(this);
    }
}

