/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class ShamelessCharlatanEffect
extends OneShotEffect {
    ShamelessCharlatanEffect() {
        super(Outcome.Benefit);
        this.staticText = "this creature becomes a copy of another target creature";
    }

    private ShamelessCharlatanEffect(ShamelessCharlatanEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShamelessCharlatanEffect copy() {
        return new ShamelessCharlatanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent copyFromPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent == null || copyFromPermanent == null) {
            return false;
        }
        game.copyPermanent(Duration.WhileOnBattlefield, copyFromPermanent, sourcePermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
        return true;
    }
}

