/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class ShannaSisaysLegacyEffect
extends ContinuousRuleModifyingEffectImpl {
    ShannaSisaysLegacyEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "{this} can't be the target of abilities your opponents control";
    }

    private ShannaSisaysLegacyEffect(ShannaSisaysLegacyEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public ShannaSisaysLegacyEffect copy() {
        return new ShannaSisaysLegacyEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            return sourcePermanent.getLogName() + " can't be the target of abilities you control";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card targetCard = game.getCard(event.getTargetId());
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        return targetCard != null && stackObject != null && targetCard.getId().equals(source.getSourceId()) && stackObject instanceof Ability && !stackObject.isControlledBy(source.getControllerId());
    }
}

