/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShaperParasiteEffect
extends ContinuousEffectImpl {
    private int power;
    private int toughness;

    public ShaperParasiteEffect() {
        super(Duration.EndOfTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.power = 2;
        this.toughness = -2;
        this.staticText = "target creature gets +2/-2 or -2/+2 until end of turn";
    }

    private ShaperParasiteEffect(ShaperParasiteEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    public ShaperParasiteEffect copy() {
        return new ShaperParasiteEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player player = game.getPlayer(source.getControllerId());
        String message = "Should the target creature get -2/+2 instead of +2/-2?";
        if (player != null && player.chooseUse(Outcome.Neutral, message, source, game)) {
            this.power *= -1;
            this.toughness *= -1;
        }
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target != null) {
            target.addPower(this.power);
            target.addToughness(this.toughness);
            return true;
        }
        return false;
    }
}

