/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ShapeshifterEffect
extends OneShotEffect {
    ShapeshifterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a number between 0 and 7.";
    }

    private ShapeshifterEffect(ShapeshifterEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShapeshifterEffect copy() {
        return new ShapeshifterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getPermanent(source.getSourceId());
        }
        if (controller != null) {
            ChoiceImpl numberChoice = new ChoiceImpl(false);
            numberChoice.setMessage("Choose a number beween 0 and 7");
            HashSet<String> numbers = new HashSet<String>();
            for (int i = 0; i <= 7; ++i) {
                numbers.add(Integer.toString(i));
            }
            numberChoice.setChoices(numbers);
            if (!controller.choose(Outcome.Neutral, (Choice)numberChoice, game)) {
                return false;
            }
            game.informPlayers("Shapeshifter, chosen number: [" + numberChoice.getChoice() + ']');
            game.getState().setValue(source.getSourceId().toString() + "_Shapeshifter", (Object)numberChoice.getChoice());
            if (mageObject instanceof Permanent) {
                mageObject.addInfo("lastChosenNumber", CardUtil.addToolTipMarkTags((String)("Last chosen number: " + numberChoice.getChoice())), game);
            }
        }
        return false;
    }
}

