/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public final class ShapeshiftersMarrow
extends CardImpl {
    public ShapeshiftersMarrow(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{U}{U}");
        this.addAbility((Ability)new BeginningOfUpkeepTriggeredAbility(TargetController.OPPONENT, (Effect)new ShapeshiftersMarrowEffect(), false));
    }

    private ShapeshiftersMarrow(ShapeshiftersMarrow card) {
        super((CardImpl)card);
    }

    public ShapeshiftersMarrow copy() {
        return new ShapeshiftersMarrow(this);
    }

    static class ShapeshiftersMarrowEffect
    extends OneShotEffect {
        public ShapeshiftersMarrowEffect() {
            super(Outcome.BecomeCreature);
            this.staticText = "that player reveals the top card of their library. If it's a creature card, the player puts the card into their graveyard and {this} becomes a copy of that card. (If it does, it loses this ability.)";
        }

        private ShapeshiftersMarrowEffect(ShapeshiftersMarrowEffect effect) {
            super((OneShotEffect)effect);
        }

        public ShapeshiftersMarrowEffect copy() {
            return new ShapeshiftersMarrowEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player activePlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            MageObject sourceObject = game.getObject(source);
            if (activePlayer != null && sourceObject != null) {
                Card card = activePlayer.getLibrary().getFromTop(game);
                if (card != null) {
                    activePlayer.revealCards(sourceObject.getIdName(), (Cards)new CardsImpl(card), game);
                    if (card.isCreature(game)) {
                        activePlayer.moveCards(activePlayer.getLibrary().getTopCards(game, 1), Zone.GRAVEYARD, source, game);
                        CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)card, source.getSourceId());
                        game.addEffect((ContinuousEffect)copyEffect, source);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

