/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.SubTypeAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class ShardConvergenceTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterCard("a Plains card, an Island card, a Swamp card, and a Mountain card");
    private static final SubTypeAssignment subTypeAssigner;

    ShardConvergenceTarget() {
        super(0, 4, filter);
    }

    private ShardConvergenceTarget(ShardConvergenceTarget target) {
        super((TargetCardInLibrary)target);
    }

    public ShardConvergenceTarget copy() {
        return new ShardConvergenceTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return subTypeAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.PLAINS.getPredicate(), SubType.ISLAND.getPredicate(), SubType.SWAMP.getPredicate(), SubType.MOUNTAIN.getPredicate()}));
        subTypeAssigner = new SubTypeAssignment(new SubType[]{SubType.PLAINS, SubType.ISLAND, SubType.SWAMP, SubType.MOUNTAIN});
    }
}

