/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.s.ShareTheSpoilsExileCardWhenPlayACardAbility;
import mage.cards.s.ShareTheSpoilsSpendAnyManaEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ShareTheSpoilsExileSingleCardEffect
extends OneShotEffect {
    ShareTheSpoilsExileSingleCardEffect() {
        super(Outcome.Exile);
        this.staticText = ", exile the top card of their library";
    }

    public boolean apply(Game game, Ability source) {
        if (source == null) {
            return false;
        }
        Player player = game.getPlayer(((ShareTheSpoilsExileCardWhenPlayACardAbility)source).getTriggeringPlayerID());
        if (player == null) {
            return false;
        }
        Card topLibraryCard = player.getLibrary().getFromTop(game);
        if (topLibraryCard == null) {
            return false;
        }
        boolean moved = player.moveCardsToExile(topLibraryCard, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        if (moved) {
            ShareTheSpoilsSpendAnyManaEffect effect = new ShareTheSpoilsSpendAnyManaEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(topLibraryCard, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return moved;
    }

    private ShareTheSpoilsExileSingleCardEffect(ShareTheSpoilsExileSingleCardEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShareTheSpoilsExileSingleCardEffect copy() {
        return new ShareTheSpoilsExileSingleCardEffect(this);
    }
}

