/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCreatureTypePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SharedAnimosityEffect
extends OneShotEffect {
    SharedAnimosityEffect() {
        super(Outcome.Benefit);
        this.staticText = "it gets +1/+0 until end of turn for each other attacking creature that shares a creature type with it";
    }

    private SharedAnimosityEffect(SharedAnimosityEffect effect) {
        super((OneShotEffect)effect);
    }

    public SharedAnimosityEffect copy() {
        return new SharedAnimosityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        FilterAttackingCreature filter = new FilterAttackingCreature();
        filter.add((Predicate)new SharesCreatureTypePredicate(permanent));
        int count = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) - 1;
        if (count > 0) {
            game.addEffect(new BoostTargetEffect(count, 0, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

