/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.s.SharedFate;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class SharedFateLookEffect
extends AsThoughEffectImpl {
    SharedFateLookEffect() {
        super(AsThoughEffectType.LOOK_AT_FACE_DOWN, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Each player may look at the cards exiled with {this}";
    }

    private SharedFateLookEffect(SharedFateLookEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public SharedFateLookEffect copy() {
        return new SharedFateLookEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (game.getState().getZone(objectId) == Zone.EXILED) {
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
            UUID exileId = CardUtil.getExileZoneId((String)SharedFate.prepareExileKey(game, source, sourcePermanent, affectedControllerId), (Game)game);
            ExileZone exileZone = game.getExile().getExileZone(exileId);
            if (exileZone != null && exileZone.contains((Object)objectId)) {
                Card card = game.getCard(objectId);
                return card != null && game.getState().getZone(objectId) == Zone.EXILED;
            }
        }
        return false;
    }
}

