/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.ManaUtil;

class SharedTraumaEffect
extends OneShotEffect {
    SharedTraumaEffect() {
        super(Outcome.Detriment);
        this.staticText = "<i>Join forces</i> &mdash; Starting with you, each player may pay any amount of mana. Each player mills X cards, where X is the total amount of mana paid this way";
    }

    private SharedTraumaEffect(SharedTraumaEffect effect) {
        super((OneShotEffect)effect);
    }

    public SharedTraumaEffect copy() {
        return new SharedTraumaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int xSum = 0;
            xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Shared Trauma", (Player)controller, (Ability)source, (Game)game);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                if (Objects.equals(playerId, controller.getId()) || (player = game.getPlayer(playerId)) == null) continue;
                xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Shared Trauma", (Player)player, (Ability)source, (Game)game);
            }
            if (xSum > 0) {
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    MillCardsTargetEffect effect = new MillCardsTargetEffect(xSum);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(playerId));
                    effect.apply(game, source);
                }
            }
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }
}

