/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SharkeyTyrantOfTheShireContinousEffect
extends ContinuousEffectImpl {
    private FilterPermanent filter;

    SharkeyTyrantOfTheShireContinousEffect(FilterPermanent filter) {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.filter = filter;
        this.staticText = "{this} has all activated abilities of " + filter.getMessage() + " except mana abilities.";
        this.addDependencyType(DependencyType.AddingAbility);
    }

    private SharkeyTyrantOfTheShireContinousEffect(SharkeyTyrantOfTheShireContinousEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.filter = effect.filter;
    }

    public SharkeyTyrantOfTheShireContinousEffect copy() {
        return new SharkeyTyrantOfTheShireContinousEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm == null) {
            return false;
        }
        for (Ability ability : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game).stream().map(permanent -> permanent.getAbilities(game)).flatMap(Collection::stream).filter(Objects::nonNull).filter(Ability::isNonManaActivatedAbility).collect(Collectors.toList())) {
            perm.addAbility(ability, source.getSourceId(), game, true);
        }
        return true;
    }
}

