/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Controllable;
import mage.game.Game;

class ShatterTheSkyEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();
    private static final Effect effect;

    ShatterTheSkyEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player who controls a creature with power 4 or greater draws a card. Then destroy all creatures";
    }

    private ShatterTheSkyEffect(ShatterTheSkyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShatterTheSkyEffect copy() {
        return new ShatterTheSkyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).stream().map(Controllable::getControllerId).distinct().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).forEach(player -> player.drawCards(1, source, game));
        effect.apply(game, source);
        return true;
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
        effect = new DestroyAllEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
    }
}

