/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ShaukuEndbringerEffect
extends RestrictionEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("another creature");

    public ShaukuEndbringerEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack if there's another creature on the battlefield.";
    }

    private ShaukuEndbringerEffect(ShaukuEndbringerEffect effect) {
        super((RestrictionEffect)effect);
    }

    public ShaukuEndbringerEffect copy() {
        return new ShaukuEndbringerEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId()) && game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) > 0;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

