/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class ShellOfTheLastKappaEffect
extends OneShotEffect {
    ShellOfTheLastKappaEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target instant or sorcery spell that targets you";
    }

    private ShellOfTheLastKappaEffect(ShellOfTheLastKappaEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShellOfTheLastKappaEffect copy() {
        return new ShellOfTheLastKappaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            Permanent sourcePermanent = game.getPermanent(source.getSourceId());
            if (sourcePermanent == null) {
                sourcePermanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
            }
            if (sourcePermanent != null) {
                game.getStack().counter(spell.getId(), source, game);
                Card card = spell.getCard();
                if (card != null) {
                    return card.moveToExile(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)sourcePermanent.getZoneChangeCounter(game)), sourcePermanent.getName(), source, game);
                }
            }
        }
        return false;
    }
}

