/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HexproofAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class ShellShieldEffect
extends OneShotEffect {
    ShellShieldEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature you control gets +0/+3 until end of turn. If this spell was kicked, that creature also gains hexproof until end of turn.";
    }

    private ShellShieldEffect(ShellShieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShellShieldEffect copy() {
        return new ShellShieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.addEffect((ContinuousEffect)new BoostTargetEffect(0, 3, Duration.EndOfTurn), source);
        if (KickedCondition.ONCE.apply(game, source)) {
            game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)HexproofAbility.getInstance(), Duration.EndOfTurn), source);
        }
        return true;
    }
}

