/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.s.ShelobChildOfUngoliantWatcher;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ShelobChildOfUngoliantTriggeredAbility
extends TriggeredAbilityImpl {
    public ShelobChildOfUngoliantTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.addWatcher(new ShelobChildOfUngoliantWatcher());
        this.setTriggerPhrase("Whenever another creature dealt damage this turn by a Spider you controlled dies, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private ShelobChildOfUngoliantTriggeredAbility(ShelobChildOfUngoliantTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ShelobChildOfUngoliantTriggeredAbility copy() {
        return new ShelobChildOfUngoliantTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        Permanent dyingPermanent;
        if (((ZoneChangeEvent)event).isDiesEvent() && StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE.match((Object)(dyingPermanent = (zEvent = (ZoneChangeEvent)event).getTarget()), game)) {
            ShelobChildOfUngoliantWatcher watcher = (ShelobChildOfUngoliantWatcher)game.getState().getWatcher(ShelobChildOfUngoliantWatcher.class);
            if (watcher == null) {
                return false;
            }
            if (!watcher.wasDamaged(this.controllerId, dyingPermanent, game)) {
                return false;
            }
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            }
            return true;
        }
        return false;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

