/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class ShelobChildOfUngoliantWatcher
extends Watcher {
    private static final FilterControlledPermanent spiderFilter = new FilterControlledPermanent(SubType.SPIDER, "spiders you controlled");
    private final Map<UUID, Set<MageObjectReference>> damagedPermanents = new HashMap<UUID, Set<MageObjectReference>>();

    public ShelobChildOfUngoliantWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PERMANENT && !game.isSimulation()) {
            Permanent damagedPermanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            Permanent spider = game.getPermanentOrLKIBattlefield(event.getSourceId());
            if (damagedPermanent == null || spider == null) {
                return;
            }
            if (!spiderFilter.match((Object)spider, game)) {
                return;
            }
            UUID playerUUID = spider.getControllerId();
            Set setForThatPlayer = this.damagedPermanents.getOrDefault(spider.getControllerId(), new HashSet());
            if (this.controllerId != null && this.controllerId.equals(game.getControllerId(event.getSourceId()))) {
                setForThatPlayer.add(new MageObjectReference(event.getTargetId(), game));
                this.damagedPermanents.put(playerUUID, setForThatPlayer);
            }
        }
    }

    public void reset() {
        super.reset();
        this.damagedPermanents.clear();
    }

    public boolean wasDamaged(UUID playerUUID, Permanent permanent, Game game) {
        if (!this.damagedPermanents.containsKey(playerUUID)) {
            return false;
        }
        return this.damagedPermanents.get(playerUUID).contains(new MageObjectReference((MageObject)permanent, game));
    }
}

