/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ShiftingShadowEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    ShiftingShadowEffect(Permanent permanent, Game game) {
        super(Outcome.Benefit);
        this.mor = new MageObjectReference((MageObject)permanent, game);
        this.staticText = "destroy this creature. Reveal cards from the top of your library until you reveal a creature card. Put that card onto the battlefield and attach " + permanent.getName() + " to it, then put all other cards revealed this way on the bottom of your library in a random order.";
    }

    private ShiftingShadowEffect(ShiftingShadowEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public ShiftingShadowEffect copy() {
        return new ShiftingShadowEffect(this);
    }

    private static Card getCard(Player player, Cards cards, Game game) {
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.isCreature(game)) continue;
            return card;
        }
        return null;
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature;
        Player player;
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.destroy(source, game);
            game.processAction();
        }
        if ((player = game.getPlayer(source.getControllerId())) == null) {
            return true;
        }
        CardsImpl cards = new CardsImpl();
        Card card = ShiftingShadowEffect.getCard(player, (Cards)cards, game);
        player.revealCards(source, (Cards)cards, game);
        if (card != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
            creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        } else {
            creature = null;
        }
        if (creature != null && this.mor.zoneCounterIsCurrent(game)) {
            creature.addAttachment(this.mor.getSourceId(), source, game);
        }
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

