/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class ShimatsuTheBloodcloakedEffect
extends ReplacementEffectImpl {
    ShimatsuTheBloodcloakedEffect() {
        super(Duration.EndOfGame, Outcome.BoostCreature);
        this.staticText = "As {this} enters, sacrifice any number of permanents. {this} enters with that many +1/+1 counters on it";
    }

    private ShimatsuTheBloodcloakedEffect(ShimatsuTheBloodcloakedEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ShimatsuTheBloodcloakedEffect copy() {
        return new ShimatsuTheBloodcloakedEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (creature != null && controller != null) {
            TargetControlledPermanent target = new TargetControlledPermanent(0, Integer.MAX_VALUE, new FilterControlledPermanent(), true);
            if (!target.canChoose(source.getControllerId(), source, game)) {
                return false;
            }
            controller.chooseTarget(Outcome.Detriment, (Target)target, source, game);
            if (!target.getTargets().isEmpty()) {
                int sacrificedCreatures = target.getTargets().size();
                game.informPlayers(controller.getLogName() + " sacrifices " + sacrificedCreatures + " creatures for " + creature.getLogName());
                for (UUID targetId : target.getTargets()) {
                    Permanent targetCreature = game.getPermanent(targetId);
                    if (targetCreature != null && targetCreature.sacrifice(source, game)) continue;
                    return false;
                }
                creature.addCounters(CounterType.P1P1.createInstance(sacrificedCreatures), source.getControllerId(), source, game);
            }
        }
        return false;
    }
}

