/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class ShowAndTellEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("artifact, creature, enchantment, or land card");

    public ShowAndTellEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Each player may put an artifact, creature, enchantment, or land card from their hand onto the battlefield";
    }

    private ShowAndTellEffect(ShowAndTellEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShowAndTellEffect copy() {
        return new ShowAndTellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LinkedHashSet<Card> cardsToPutIntoPlay = new LinkedHashSet<Card>();
        TargetCardInHand target = new TargetCardInHand(filter);
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Card card;
            Player player = game.getPlayer(playerId);
            if (player == null || !player.chooseUse(this.outcome, "Put an artifact, creature, enchantment, or land card from hand onto the battlefield?", source, game)) continue;
            target.clearChosen();
            if (!player.chooseTarget(this.outcome, (Target)target, source, game) || (card = game.getCard(target.getFirstTarget())) == null) continue;
            cardsToPutIntoPlay.add(card);
        }
        return controller.moveCards(cardsToPutIntoPlay, Zone.BATTLEFIELD, source, game, false, false, true, null);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

