/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ShrivelingRotEffect
extends OneShotEffect {
    ShrivelingRotEffect() {
        super(Outcome.LoseLife);
        this.staticText = "that creature's controller loses life equal to its toughness";
    }

    private ShrivelingRotEffect(ShrivelingRotEffect effect) {
        super((OneShotEffect)effect);
    }

    public ShrivelingRotEffect copy() {
        return new ShrivelingRotEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            if (permanent.getZoneChangeCounter(game) + 1 == game.getState().getZoneChangeCounter(permanent.getId()) && game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) {
                return true;
            }
            Player permanentController = game.getPlayer(permanent.getControllerId());
            if (permanentController != null) {
                int amount = permanent.getToughness().getValue();
                permanentController.loseLife(amount, game, source, false);
                return true;
            }
        }
        return false;
    }
}

