/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.s.ShrivelingRotEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ShrivelingRotLoseLifeTriggeredAbility
extends DelayedTriggeredAbility {
    ShrivelingRotLoseLifeTriggeredAbility() {
        super((Effect)new ShrivelingRotEffect(), Duration.EndOfTurn, false);
    }

    private ShrivelingRotLoseLifeTriggeredAbility(ShrivelingRotLoseLifeTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public ShrivelingRotLoseLifeTriggeredAbility copy() {
        return new ShrivelingRotLoseLifeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget().isCreature(game)) {
            Effect effect = (Effect)this.getEffects().get(0);
            effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Until end of turn, whenever a creature dies, that creature's controller loses life equal to its toughness.";
    }
}

