/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.FoodToken;
import mage.players.Player;

class SidequestCatchAFishEffect
extends OneShotEffect {
    SidequestCatchAFishEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's an artifact or creature card, you may reveal it and put it into your hand. If you put a card into your hand this way, create a Food token and transform this enchantment.";
    }

    private SidequestCatchAFishEffect(SidequestCatchAFishEffect effect) {
        super((OneShotEffect)effect);
    }

    public SidequestCatchAFishEffect copy() {
        return new SidequestCatchAFishEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card topCard = controller.getLibrary().getFromTop(game);
        if (topCard == null) {
            return false;
        }
        controller.lookAtCards("Top card of library", topCard, game);
        if ((topCard.isArtifact(game) || topCard.isCreature(game)) && controller.chooseUse(Outcome.DrawCard, "Reveal " + topCard.getName() + " and put it into your hand?", source, game)) {
            controller.revealCards(source, (Cards)new CardsImpl(topCard), game);
            controller.moveCards(topCard, Zone.HAND, source, game);
            new FoodToken().putOntoBattlefield(1, game, source);
            new TransformSourceEffect().apply(game, source);
            return true;
        }
        return true;
    }
}

