/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class SidequestPlayBlitzballEffect
extends OneShotEffect {
    SidequestPlayBlitzballEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then attach it to a creature you control";
    }

    private SidequestPlayBlitzballEffect(SidequestPlayBlitzballEffect effect) {
        super((OneShotEffect)effect);
    }

    public SidequestPlayBlitzballEffect copy() {
        return new SidequestPlayBlitzballEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source, game, 1)) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        return Optional.ofNullable(target.getFirstTarget()).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(p -> p.addAttachment(p.getId(), source, game)).orElse(false);
    }
}

