/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SidequestPlayBlitzballWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    SidequestPlayBlitzballWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && ((DamagedEvent)event).isCombatDamage()) {
            this.map.compute(event.getTargetId(), (u, i) -> i == null ? event.getAmount() : Integer.sum(i, event.getAmount()));
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    private boolean checkMap(UUID playerId) {
        return this.map.getOrDefault(playerId, 0) >= 6;
    }

    static boolean checkPlayers(Game game, Ability source) {
        return game.getState().getPlayersInRange(source.getControllerId(), game).stream().anyMatch(((SidequestPlayBlitzballWatcher)game.getState().getWatcher(SidequestPlayBlitzballWatcher.class))::checkMap);
    }
}

