/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class SiegeStrikerEffect
extends OneShotEffect {
    public SiegeStrikerEffect() {
        super(Outcome.GainLife);
        this.staticText = "you may tap any number of untapped creatures you control. {this} gets +1/+1 until end of turn for each creature tapped this way";
    }

    private SiegeStrikerEffect(SiegeStrikerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int tappedAmount = 0;
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURES, true);
        target.choose(Outcome.Tap, source.getControllerId(), source.getSourceId(), source, game);
        for (UUID creatureId : target.getTargets()) {
            Permanent creature = game.getPermanent(creatureId);
            if (creature == null) continue;
            creature.tap(source, game);
            ++tappedAmount;
        }
        if (tappedAmount > 0) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(tappedAmount, tappedAmount, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }

    public SiegeStrikerEffect copy() {
        return new SiegeStrikerEffect(this);
    }
}

