/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class SiftThroughSandsWatcher
extends Watcher {
    boolean castPeerThroughDepths = false;
    boolean castReachThroughMists = false;

    public SiftThroughSandsWatcher() {
        super(WatcherScope.PLAYER);
    }

    public void watch(GameEvent event, Game game) {
        if (this.condition) {
            return;
        }
        if (event.getType() == GameEvent.EventType.SPELL_CAST && this.controllerId.equals(event.getPlayerId())) {
            Spell spell = game.getStack().getSpell(event.getTargetId());
            if (spell.getCard().getName().equals("Peer Through Depths")) {
                this.castPeerThroughDepths = true;
            } else if (spell.getCard().getName().equals("Reach Through Mists")) {
                this.castReachThroughMists = true;
            }
            this.condition = this.castPeerThroughDepths && this.castReachThroughMists;
        }
    }

    public void reset() {
        super.reset();
        this.castPeerThroughDepths = false;
        this.castReachThroughMists = false;
    }
}

