/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.CardsInControllerGraveyardCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class SigilOfMyrkulEffect
extends OneShotEffect {
    private static final Condition condition = new CardsInControllerGraveyardCondition(4, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);

    SigilOfMyrkulEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill a card. When you do, if there are four or more creature cards in your graveyard, put a +1/+1 counter on target creature you control and it gains deathtouch until end of turn";
    }

    private SigilOfMyrkulEffect(SigilOfMyrkulEffect effect) {
        super((OneShotEffect)effect);
    }

    public SigilOfMyrkulEffect copy() {
        return new SigilOfMyrkulEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.millCards(1, source, game).isEmpty()) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), false, "if there are four or more creature cards in your graveyard, put a +1/+1 counter on target creature you control and it gains deathtouch until end of turn", condition);
        ability.addEffect((Effect)new GainAbilityTargetEffect((Ability)DeathtouchAbility.getInstance()));
        ability.addTarget((Target)new TargetControlledCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

