/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SilenceTheBelieversExileEffect
extends OneShotEffect {
    SilenceTheBelieversExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile any number of target creatures and all Auras attached to them";
    }

    private SilenceTheBelieversExileEffect(SilenceTheBelieversExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public SilenceTheBelieversExileEffect copy() {
        return new SilenceTheBelieversExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Permanent creature = game.getPermanent(targetId);
                if (creature == null) continue;
                ArrayList attachments = new ArrayList(creature.getAttachments());
                for (UUID attachmentId : attachments) {
                    Permanent attachment = game.getPermanent(attachmentId);
                    if (attachment == null || !attachment.hasSubtype(SubType.AURA, game)) continue;
                    controller.moveCardToExileWithInfo((Card)attachment, null, null, source, game, Zone.BATTLEFIELD, true);
                }
                controller.moveCardToExileWithInfo((Card)creature, null, null, source, game, Zone.BATTLEFIELD, true);
            }
            return true;
        }
        return false;
    }
}

