/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class SilumgarScavengerExploitedWatcher
extends Watcher {
    private final Map<UUID, Integer> exploitedPermanents = new HashMap<UUID, Integer>();

    SilumgarScavengerExploitedWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.EXPLOITED_CREATURE && (permanent = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null) {
            this.exploitedPermanents.put(permanent.getId(), permanent.getZoneChangeCounter(game));
        }
    }

    public void reset() {
        super.reset();
        this.exploitedPermanents.clear();
    }

    boolean isPermanentExploited(Game game, UUID permanentId) {
        Permanent currentPerm = game.getPermanentOrLKIBattlefield(permanentId);
        if (currentPerm != null && this.exploitedPermanents.containsKey(currentPerm.getId())) {
            int currentZone = currentPerm.getZoneChangeCounter(game);
            return currentZone == this.exploitedPermanents.get(currentPerm.getId());
        }
        return false;
    }
}

