/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.s.SimianSlingEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SimianSlingTriggeredAbility
extends TriggeredAbilityImpl {
    SimianSlingTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SimianSlingEffect());
    }

    private SimianSlingTriggeredAbility(SimianSlingTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SimianSlingTriggeredAbility copy() {
        return new SimianSlingTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATURE_BLOCKED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (!(event.getTargetId().equals(this.getSourceId()) || (permanent = this.getSourcePermanentOrLKI(game)) != null && event.getTargetId().equals(permanent.getAttachedTo()))) {
            return false;
        }
        this.getEffects().setValue("attacker", (Object)event.getTargetId());
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(game.getCombat().getDefendingPlayerId(event.getTargetId(), game)));
        return true;
    }

    public String getRule() {
        return "Whenever {this} or equipped creature becomes blocked, it deals 1 damage to defending player.";
    }
}

