/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SimoonEffect
extends OneShotEffect {
    SimoonEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 1 damage to each creature target opponent controls";
    }

    private SimoonEffect(SimoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public SimoonEffect copy() {
        return new SimoonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(player.getId()));
            List creatures = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game);
            for (Permanent creature : creatures) {
                creature.damage(1, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

