/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SinUnendingCataclysmEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("artifacts, creatures, and enchantments");

    SinUnendingCataclysmEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove all counters from any number of artifacts, creatures, and enchantments. {this} enters with X +1/+1 counters on it, where X is twice the number of counters removed this way";
    }

    private SinUnendingCataclysmEffect(SinUnendingCataclysmEffect effect) {
        super((OneShotEffect)effect);
    }

    public SinUnendingCataclysmEffect copy() {
        return new SinUnendingCataclysmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        int count = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent permanent2 = game.getPermanent(targetId);
            if (permanent2 == null) continue;
            Set counters = permanent2.getCounters(game).entrySet().stream().map(e -> CounterType.findByName((String)((String)e.getKey())).createInstance(((Counter)e.getValue()).getCount())).collect(Collectors.toSet());
            for (Counter counter : counters) {
                count += permanent2.removeCounters(counter, source, game);
            }
        }
        if (count < 1) {
            return false;
        }
        Counter counter = CounterType.P1P1.createInstance(2 * count);
        Optional.ofNullable(source).map(Ability::getSourceId).map(arg_0 -> ((Game)game).getPermanentEntering(arg_0)).ifPresent(permanent -> permanent.addCounters(counter, source, game));
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate()}));
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

