/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SindbadEffect
extends OneShotEffect {
    SindbadEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw a card and reveal it. If it isn't a land card, discard it";
    }

    private SindbadEffect(SindbadEffect effect) {
        super((OneShotEffect)effect);
    }

    public SindbadEffect copy() {
        return new SindbadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (controller.drawCards(1, source, game) != 1) {
            return true;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        if (!card.isLand(game)) {
            controller.discard(card, false, source, game);
        }
        return true;
    }
}

