/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class SingleCombatRestrictionEffect
extends ContinuousRuleModifyingEffectImpl {
    SingleCombatRestrictionEffect() {
        super(Duration.UntilEndOfYourNextTurn, Outcome.Neutral);
        this.staticText = "Players can't cast creature or planeswalker spells until the end of your next turn";
    }

    private SingleCombatRestrictionEffect(SingleCombatRestrictionEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SingleCombatRestrictionEffect copy() {
        return new SingleCombatRestrictionEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getSourceId());
        return card != null && (card.isCreature(game) || card.isPlaneswalker(game));
    }
}

