/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SinnersJudgmentEffect
extends OneShotEffect {
    SinnersJudgmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if there are three or more judgment counters on it, enchanted player loses the game";
    }

    private SinnersJudgmentEffect(SinnersJudgmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public SinnersJudgmentEffect copy() {
        return new SinnersJudgmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return Optional.ofNullable(source.getSourcePermanentOrLKI(game)).filter(permanent -> permanent.getCounters(game).getCount(CounterType.JUDGMENT) >= 3).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(player -> {
            player.lost(game);
            return true;
        }).isPresent();
    }
}

