/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SiphonInsightEffect
extends OneShotEffect {
    private static final String VALUE_PREFIX = "ExileZones";

    public SiphonInsightEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top two cards of target opponent's library. Exile one of them face down and put the other on the bottom of that library. You may look at and play the exiled card for as long as it remains exiled, and you may spend mana as though it were mana of any color to cast that spell";
    }

    private SiphonInsightEffect(SiphonInsightEffect effect) {
        super((OneShotEffect)effect);
    }

    public SiphonInsightEffect copy() {
        return new SiphonInsightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || opponent == null || sourceObject == null) {
            return false;
        }
        CardsImpl topCards = new CardsImpl();
        topCards.addAllCards((Collection)opponent.getLibrary().getTopCards(game, 2));
        TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to exile"));
        controller.choose(this.outcome, (Cards)topCards, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            controller.putCardsOnBottomOfLibrary((Cards)topCards, game, source, false);
            return true;
        }
        new ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(false, CastManaAdjustment.AS_THOUGH_ANY_MANA_COLOR).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
        topCards.retainZone(Zone.LIBRARY, game);
        controller.putCardsOnBottomOfLibrary((Cards)topCards, game, source, false);
        return true;
    }
}

