/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.LinkedList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class SistersOfStoneDeathEffect
extends OneShotEffect {
    SistersOfStoneDeathEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put a creature card exiled with {this} onto the battlefield under your control";
    }

    private SistersOfStoneDeathEffect(SistersOfStoneDeathEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ExileZone exile;
        CardsImpl cardsInExile = new CardsImpl();
        TargetCard target = new TargetCard(Zone.EXILED, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (exile = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source))) != null) {
            LinkedList cards = new LinkedList(exile);
            for (UUID cardId : cards) {
                Card card = game.getCard(cardId);
                if (card == null) continue;
                cardsInExile.add(card);
            }
            if (controller.choose(Outcome.PutCreatureInPlay, (Cards)cardsInExile, target, source, game)) {
                Card chosenCard = game.getCard(target.getFirstTarget());
                return controller.moveCards(chosenCard, Zone.BATTLEFIELD, source, game);
            }
        }
        return false;
    }

    public SistersOfStoneDeathEffect copy() {
        return new SistersOfStoneDeathEffect(this);
    }
}

