/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SithEternalLightningEffect
extends OneShotEffect {
    SithEternalLightningEffect() {
        super(Outcome.Benefit);
        this.staticText = "Tap all creatures your opponents control. Those creatures don't untap during their controller's next untap step.";
    }

    private SithEternalLightningEffect(SithEternalLightningEffect effect) {
        super((OneShotEffect)effect);
    }

    public SithEternalLightningEffect copy() {
        return new SithEternalLightningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set opponents = game.getOpponents(controller.getId());
        if (opponents != null) {
            for (UUID opponent : opponents) {
                List permanents = game.getBattlefield().getActivePermanents(opponent, game);
                for (Permanent permanent : permanents) {
                    if (!permanent.isCreature(game) || !opponent.equals(permanent.getControllerId())) continue;
                    permanent.tap(source, game);
                    DontUntapInControllersNextUntapStepTargetEffect effect = new DontUntapInControllersNextUntapStepTargetEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

