/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SkredDamageEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("equal to the number of snow permanents you control.");

    public SkredDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to target creature equal to the number of snow permanents you control.";
    }

    private SkredDamageEffect(SkredDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkredDamageEffect copy() {
        return new SkredDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (amount > 0 && permanent != null) {
            permanent.damage(amount, source.getSourceId(), source, game, false, true);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SuperType.SNOW.getPredicate());
    }
}

