/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SkulduggeryEffect
extends OneShotEffect {
    SkulduggeryEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Until end of turn, target creature you control gets +1/+1 and target creature an opponent controls gets -1/-1";
    }

    private SkulduggeryEffect(SkulduggeryEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkulduggeryEffect copy() {
        return new SkulduggeryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        BoostTargetEffect effect;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            effect = new BoostTargetEffect(1, 1, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        if ((permanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            effect = new BoostTargetEffect(-1, -1, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

