/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SkullRaidEffect
extends OneShotEffect {
    SkullRaidEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent discards two cards. If fewer than two cards were discarded this way, you draw cards equal to the difference";
    }

    private SkullRaidEffect(SkullRaidEffect effect) {
        super((OneShotEffect)effect);
    }

    public SkullRaidEffect copy() {
        return new SkullRaidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        int discarded = opponent.discard(2, false, false, source, game).size();
        if (discarded >= 2) {
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.drawCards(2 - discarded, source, game);
        }
        return true;
    }
}

