/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public final class SkullRend
extends CardImpl {
    public SkullRend(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{3}{B}{R}");
        this.getSpellAbility().addEffect((Effect)new SkullRendEffect());
    }

    private SkullRend(SkullRend card) {
        super((CardImpl)card);
    }

    public SkullRend copy() {
        return new SkullRend(this);
    }

    private static class SkullRendEffect
    extends OneShotEffect {
        private SkullRendEffect() {
            super(Outcome.Damage);
            this.staticText = "{this} deals 2 damage to each opponent. Those players each discard two cards at random";
        }

        private SkullRendEffect(SkullRendEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            List opponents = game.getOpponents(source.getControllerId()).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            for (Player opponent : opponents) {
                opponent.damage(2, source.getSourceId(), source, game);
            }
            for (Player opponent : opponents) {
                opponent.discard(2, true, false, source, game);
            }
            return true;
        }

        public SkullRendEffect copy() {
            return new SkullRendEffect(this);
        }
    }
}

